import os
import re
import sys

from qgis.PyQt.QtCore import QCoreApplication, QFileSystemWatcher, QSettings
from qgis.PyQt.QtGui import QIcon, QPixmap
from qgis.PyQt.QtWidgets import QApplication, QSplashScreen

# Base path for the icons directory
IMAGES_DIR = os.path.join(os.path.dirname(__file__), "images")


def reload_style(path):
    # Some applications will remove a file and rewrite it.  QFileSystemWatcher will
    # ignore the file if the file handle goes away so we have to keep adding it.
    watch.removePaths(watch.files())
    watch.addPath(path)
    with open(path, "r") as f:
        stylesheet = f.read()
        # Update the image paths to use full paths. Fixes image loading in styles
        path = os.path.dirname(path).replace("\\", "/")
        stylesheet = re.sub(r"url\((.*?)\)", r'url("{}/\1")'.format(path), stylesheet)
        QApplication.instance().setStyleSheet(stylesheet)


watch = QFileSystemWatcher()
watch.fileChanged.connect(reload_style)


class RanaQgisCustomisations:
    def __init__(self, iface):
        self.iface = iface
        self.plugin_dir = os.path.dirname(__file__)

        self.windowTitle = "Rana Desktop Client - Powered by QGIS"

        self.app = QApplication.instance()
        self.QApp = QCoreApplication.instance()

        if self.QApp is None:
            self.QApp = QApplication(sys.argv)

        self.QApp.startingUp()
        self.QApp.processEvents()
        self.app.startDragTime()

        self.iface.initializationCompleted.connect(self.customization)
        QApplication.instance().processEvents()

        self.applyStyle()

    def initGui(self):
        QSettings().setValue("/qgis/hideSplash", True)
        QApplication.instance().processEvents()

        icon = QIcon(os.path.join(IMAGES_DIR, "logo.png"))
        self.app.setWindowIcon(icon)
        self.iface.mainWindow().setWindowIcon(icon)
        self.iface.mainWindow().setWindowTitle(self.windowTitle)

        QApplication.instance().processEvents()

        if not self.iface.mainWindow().isVisible():
            self.splash_pix = QPixmap(os.path.join(IMAGES_DIR, "splash.png"))
            self.splash = QSplashScreen(self.splash_pix)
            self.splash.setMask(self.splash_pix.mask())
            self.splash.show()
            QApplication.instance().processEvents()
        self.applyStyle()

    def run(self):
        pass

    def unload(self):
        QApplication.instance().processEvents()
        self.iface.initializationCompleted.disconnect(self.customization)

    def customization(self):
        self.splash.finish(self.iface.mainWindow())
        self.iface.mainWindow().setWindowTitle(self.windowTitle)
        QApplication.instance().processEvents()
        self.applyStyle()

    def applyStyle(self):
        path = os.path.abspath(os.path.join(self.plugin_dir, "stylesheet.qss"))
        watch.removePaths(watch.files())
        reload_style(path)
